#################################################################
### Funksjon for  Lage ny VM ut ifra template.               ###

# Add-PSSnapin for SCVMM.
try {
    # Test for snapin og tilkobling til vmm-server
    Add-PSSnapin microsoft.systemcenter.virtualmachinemanager
    Get-VMMServer -ComputerName scvmm
}
catch {
}

# Funksjonshode med maskinnavn som innargument
function New-vm-from-template ($vmname="", $vmcount=1) {

    # Avbryt hvis navn ikke er angitt
    if ($vmname -eq $null -or $vmname -eq "") {
    write-host "Ingen maskinnavnstandard gitt!"
    return
    }

    # Hente host Informasjon - statisk
    $VMHost = Get-VMHost -VMMServer SCVMM | where {$_.Name -eq "hyp-1.mafoberg.net"}

    # Hente template-informasjon - statisk
    $Template = Get-Template -VMMServer SCVMM | where {$_.Name -eq "Serber 2008 R2 _clean"}


    for ($i = 1; $i -le $vmcount; $i++) {
        Write-host "Maskin $i - $vname"
        
        # Generering av JobGroup ID
        $TemplateJobGroup = [System.Guid]::NewGuid()
        
        # Ny maskinjobb
        New-VM -Template $Template -Name ($vmname+$i) -VMHost $VMHost -Path "C:\ClusterStorage\Volume1" `
        -JobGroup $TemplateJobGroup -RunAsynchronously -Owner "MAFOBERG\Administrator" -AnswerFile $null `
        -RunAsSystem -StartAction NeverAutoTurnOnVM -StopAction SaveVM
     }
}

